# 7. Live Entity (LE) Information/Interaction protocol

This clause contains the specification of a protocol for use in DIS applications where conservation of network bandwidth is a prime concern. Although created primarily for use by systems involving live entities communicating over bandwidth-limited communication mechanisms, it is available for other similar uses. With the exception of references to record definitions found in Clause 5, this clause is self-contained consisting of an overview of the major architectural principles upon which this protocol is based, the definition of protocol-specific data structures, and the specification of the PDUs that constitute the LE Information/Interaction protocol. In support of the reduction in communications channel bandwidth needed by the elements of this protocol, the PDUs of this protocol are not required to adhere to the record alignment requirements of 5.3.1.

# 7.1 Architectural principles

The LE Information/Interaction protocol relies on specific architectural principles that differ from those upon which the previous clauses of this standard are based. The primary need for these protocol-specific principles is the limited communications bandwidth available to an LE participating in a DIS exercise. The following are the major architecture changes:

a) Increase in the maximum allowable transmission interval for the purposes of dead reckoning  
b) Conversion of floating point fields to fixed binary fields  
c) Decrease in the length of the fields constituting a PDU  
d) Allowance for one or more subprotocol definitions that specify field lengths and format to be selected for use in an exercise prior to the start of an exercise  
e) Allowance for some fields in some PDUs to be optional

In addition to the above, several architecture augmentations, summarized in Table 128, are required to support the special needs of live participants in a DIS exercise.

Table 128—Architecture augmentations for supporting LE  

<table><tr><td>Augmentation</td><td>Rationale</td></tr><tr><td>Reduce length of frequently transmitted data</td><td>Break Entity State PDU into multiple PDUs so that they may be transmitted at different intervals and so that slowly changing information need not be reported as frequently as quickly changing information.Reduce the size of the PDU fields by eliminating implied precision that does not match the accuracy of the data measured.</td></tr><tr><td>Eliminate unused or nonchanging fields in PDUs</td><td>Some information on some platforms cannot be supplied because it is not instrumented. A field containing a set of bit flags is included in some PDUs to signal the presence or absence of specific optional fields.</td></tr><tr><td>Use reference points for specification of LE location</td><td>By distributing, prior to an exercise, the 64-bit floating point world coordinate locations of a series of geographic reference points specific to the exercise domain, an LE&#x27;s actual location can be communicated by means of a triplet of delta distances from a given reference point and the identification of the reference point.</td></tr></table>

In order to reduce the communication bandwidth needed during an exercise, certain unchanging exercise-specific data can be made available to the simulation applications prior to the start of an exercise in a stan

dard format. Specifically the LE Information/Interaction protocol uses a system of geographic reference points that can be defined and distributed prior to an exercise. These predefined reference points allow the actual location of an LE to be transmitted as delta offsets from one of these reference points. The suggested reference point file definition format is shown in Table 129, and the fields of this file format are as follows:

a) Version. This field shall specify the version identification of the data file and shall be represented by a 16-bit unsigned integer.  
b) Number of Reference Points. This field shall specify the number of 64-bit triplets of world location data that follow in the file. This field shall be represented by a 16-bit unsigned integer.  
c) Reference Point. This field shall specify the location of each reference point in the simulated world. This field shall be represented by a World Coordinates record (see 5.2.34)

Table 129—Reference Point File Definition Format  

<table><tr><td colspan="2">Version</td><td>16-bit unsigned integer</td></tr><tr><td colspan="2">Number of reference points (NR)</td><td>16-bit unsigned integer</td></tr><tr><td rowspan="3">Reference point (1 - NR)</td><td>World-X</td><td>64-bit floating point</td></tr><tr><td>World-Y</td><td>64-bit floating point</td></tr><tr><td>World-Z</td><td>64-bit floating point</td></tr></table>

Each reference point is logically assigned the next sequential number starting with zero.

The translation of a reference-point-based location (ref-  $n$ , Delta-  $X$ , Delta-  $Y$ , Delta-  $Z$ ) into a standard WGS-84  $X$ ,  $Y$ ,  $Z$  triplet shall be as shown below:

$$
X = \text {W o r l d - X} (\text {r e f - n}) + \text {D e l t a - X}
$$

$$
Y = \text {W o r l d - Y} (\text {r e f - n}) + \text {D e l t a - Y}
$$

$$
Z = \text {W o r l d - Z} (\text {r e f - n}) + \text {D e l t a - Z}
$$

The translation into a reference-based location is based on finding the reference point that minimizes the delta offsets from that reference point.

# 7.2 Basic records

This subclause specifies requirements for records specific to the LE Information/Interaction protocol. Enumeration values and bit-encoded values are given of EBV-DOC unless otherwise stated.

# 7.2.1 LE PDU Header record

An LE PDU Header record shall be the first part of each LE Information/Interaction PDU. The fields of this record are as follows:

a) Protocol Version. This field shall specify the version of protocol used in this PDU and shall be specified by an 8-bit enumeration. The values for this field are defined in Section 3 of EBV-DOC.  
b) Exercise ID. This field shall specify the exercise to which the PDU pertains and shall be represented by an Exercise Identifier (see 5.2.19).

c) PDU Type. This field shall indicate the type of PDU that follows. This field shall be represented by an 8-bit enumeration. The values in this field are defined in Section 3 of EBV-DOC.  
d) Protocol Family. This field shall indicate the family of protocols to which the PDU belongs. This field shall be represented by an 8-bit enumeration. The values in this field are defined in Section 3 of EBV-DOC.  
e) Timestamp. This field shall specify the time that the data in the PDU were generated and shall be represented by a Timestamp (see 5.2.31).  
f) Length. This field shall specify the length of the PDU, including the PDU header, in octets, and shall be represented by an 16-bit unsigned integer.  
g) Subprotocol Number. This field shall specify the subprotocol to be used to decode the PDU. This field is represented by an 8-bit enumerations (see Section 13 of EBV-DOC). The value of zero is reserved for PDUs that are defined according to the requirements in Clauses 4 and 5 of this standard.  
h) Padding. Although padding fields are not normally used in the LE Information/Interaction PDUs, the LE PDU Header record is padded so that it maintains the same length as the PDU Header in 5.2.24.

The format of the LE PDU Header record shall be as shown in Table 130.

Table 130—LE PDU Header record  

<table><tr><td>Protocol Version</td><td>8-bit enumeration</td></tr><tr><td>Exercise ID</td><td>8-bit unsigned integer</td></tr><tr><td>PDU Type</td><td>8-bit enumeration</td></tr><tr><td>Protocol Family</td><td>8-bit enumeration</td></tr><tr><td>Timestamp</td><td>32-bit unsigned integer</td></tr><tr><td>Length</td><td>16-bit unsigned integer</td></tr><tr><td>Subprotocol Number</td><td>8-bit enumeration</td></tr><tr><td>Padding</td><td>8 bits unused</td></tr></table>

# 7.2.2 Relative World Coordinates record

Location of the origin of the LE's coordinate system shall be specified by a set of four data values: reference point, Delta-  $X$ , Delta-  $Y$ , and Delta-  $Z$ . The shape of the earth and the origin and orientation of this coordinate system shall be as defined in 1.3.2. The fields of this record are as follows:

a) Reference Point. This field shall identify the number of the reference point against which the Delta-  $X$ , Delta-  $Y$ , and Delta-  $Z$  distances are calculated. This field shall be represented by a 16-bit unsigned integer.  
b) Delta-  $X$ . This field shall specify the difference between LE's  $X$ -direction coordinate and the  $X$ -direction coordinate of the reference point. This field shall be represented by a 16-bit fixed binary number. The binary point is defined by the subprotocol, but for the purposes of this standard the binary point shall be assumed to be 3 (i.e., the least significant bit shall represent  $0.125\mathrm{m}$ ).  
c) Delta-Y. This field shall specify the difference between LE's  $Y$ -direction coordinate, and the  $Y$ -direction coordinate of the reference point. This field shall be represented by a 16-bit fixed binary number. The binary point is defined by the subprotocol, but for the purposes of this standard the binary point shall be assumed to be 3 (i.e., the least significant bit shall represent  $0.125\mathrm{m}$ ).  
d) Delta-Z. This field shall specify the difference between LE's Z-direction coordinate and the Z-direction coordinate of the reference point. This field shall be represented by a 16-bit fixed binary num

ber. The binary point is defined by the subprotocol, but for the purposes of this standard the binary point shall be assumed to be 3 (i.e., the least significant bit shall represent  $0.125\mathrm{m}$ ).

The format of the Relative World Coordinates record shall be as shown in Table 131.

Table 131—Relative World Coordinates record  

<table><tr><td>Reference Point</td><td>16-bit unsigned integer</td></tr><tr><td>Delta-X</td><td>16-bit fixed binary</td></tr><tr><td>Delta-Y</td><td>16-bit fixed binary</td></tr><tr><td>Delta-Z</td><td>16-bit fixed binary</td></tr></table>

# 7.2.3 Position Error record

This record defines the error components that are associated with the location measurement for an entity. These errors are measured in entity-centered tangent planes. Different error factors are associated with the horizontal and vertical error measurements. The binary point is defined by the subprotocol, but for the purposes of this standard the binary point will be assumed to be 3 (i.e., the least significant bit shall represent  $0.125\mathrm{m}$ ). The format of the Position Error record shall be as shown in Table 132.

Table 132-Position Error record  

<table><tr><td>Horizontal Error</td><td>16-bit fixed binary</td></tr><tr><td>Vertical Error</td><td>16-bit fixed binary</td></tr></table>

# 7.2.4 Orientation Error record

This record defines the orientation error components that are associated with the measurement of the entity's orientation. Units of measurement are in radians. The binary point is defined by the subprotocol, but for the purposes of this standard the binary point shall be 8 (i.e., the least significant bit shall represent 0.0039062 rad). The format of the Orientation Error record shall be as shown in Table 133.

Table 133—Orientation Error record  

<table><tr><td>Azimuth Error</td><td>16-bit fixed binary</td></tr><tr><td>Elevation Error</td><td>16-bit fixed binary</td></tr><tr><td>Rotation Error</td><td>16-bit fixed binary</td></tr></table>

# 7.3 LE Information/Interaction protocol family

The LE Information/Interaction protocol consists of the following PDUs:

a) Time Space Position Information (TSPI) PDU  
b) Appearance PDU